
# patch for opt bug DR 81988
# will be included in train2
# Opt crashes with opt_area twolevel recipe.


func espresso(args option) {
	string espin
	int rc
	string plaout

	espin = (gc_scratchopen espin c)[1]
	wr_pla @espin
	plaout = (gc_scratchopen plaout c)[1]
	if (!@option) (option = "-Dso_both")
	rc = (sys  (cat @Prog.Espresso " "  @option " < " @espin " > " @plaout ))
	if (! @rc) {
		opt_area_rd_pla @plaout
	} 
	sys_unlink @plaout
	sys_unlink @espin
	if @rc (error "espresso failed")
}

func opt_area_rd_pla (args fname) {
        file fp
        int rc
        string  outfile
        fp = (rd_openfile @fname)
        if (! @fp ){
            error Cannot open file @fname for read
        }
        rc = (readesp @fp)
        fclose @fp
        if @rc {
                eprintf "Failed to read pla: %s\n" (errorinfo)
                return ()
        }
        popinv
        makenetcomps
        widegates 3
        lo_removedups @Netlist
        set Newfile 1
/* Fix for crash in twolevel opt */
	lo_sortnetlistports @Netlist
/* sortnetlist ports fixes problem reported as DR84698*/
        lo_postreadnetlist @Netlist
        return @Netlist
}

func rd_pla (args fname) {
	file fp
	int rc 
	string  outfile

	fp = (rd_openfile @fname)
	if (! @fp ){
	    error Cannot open file @fname for read
	}
	lo_clearprops @Netlist._view
	rc = (readesp @fp)
	fclose @fp
	if @rc {
		eprintf "Failed to read pla: %s\n" (errorinfo)
		return ()
	}
	popinv
	makenetcomps
	widegates 3
	lo_removedups @Netlist
	set Newfile 1
/* Fix for crash in twolevel opt */
        lo_sortnetlistports @Netlist
/* sortnetlist ports fixes problem reported as DR84698*/
	lo_postreadnetlist @Netlist
	return @Netlist
}

